/*  Esercizio: implementare una classe Coda che gestisce una coda di numeri interi, e una classe Main che ne esegue il test.
    Una coda una struttura dati che memorizza una lista di elementi, accessibili tramite la modalità FIFO, First In First Out.
        Le operazioni che si possono fare su una pila sono 2:
         - inserimento di un elemento: viene inserito un nuovo elemento alla fine,
         - rimozione di un elemento: viene rimosso il primo elemento della lista.
    Un esempio di coda è la fila per entrare in una giostra: la persona che entra per prima nella coda, sara' la prima a uscirne 
    per entrare nella giostra, e quando ciò avviene tutte le altre persone si spostano avanti di un posto; invece una nuova 
    persona si aggiunge alla coda in ultima posizione.
    
    La classe Coda conterrà:
         - attributo: un array di interi, per memorizzati i numeri interi,
         - metodi: enqueue(int) che effettua l'inserimento di un intero alla fine della coda;
                   dequeue () che rimuove, se presente, il primo elemento della coda (cioè quello inserito meno recentemente) e lo restituisce;
                   getNumElementi() che restituisce il numero di elementi presenti nella pila.
         - metodo opzionale: toString() che restituisce una stringa descrittiva contenente gli elementi dell'array
*/

public class Coda
{
    //array per memorizzare i dati
    int[] arr = new int[0];
    
    //metodo per inserire un nuovo elemento nella coda: quando si inserisce un elemento, si deve creare un nuovo array
    //di dimensione incrementata di 1, copiare il vecchio array e insierire nel'ultima posizione il nuovo elemento
    public void enqueue(int val)
    {
        //si crea un array con una posizione in piu'
        int[] newArr = new int[arr.length +1];
        //si copia l'array nel nuovo array
        for(int i = 0; i < arr.length; i++)
            newArr[i] = arr[i];
        //l'ultimo elemento sara' quello in input
        newArr[newArr.length -1] = val;
        //si salva il nuovo array nella variabile di istanza, sostituendo l'array vecchio
        arr = newArr;
    }

    //metodo per rimuovere il primo l'elemento della coda: quando si rimuove un elemento, si deve creare un nuovo array
    //di dimensione decrementata di 1, poi copiare il vecchio array ad eccezione l'elemento rimosso (cioè il primo dell'array)
    public int dequeue()
    {
        //si controlla che l'array abbia almeno un elemento da rimuovere
        if(arr.length < 1)
            return -1;
        //si salva il primo elemento, che sara' ritornato dalla funzione
        int val = arr[0];
        //si crea un array con una posizione in meno
        int[] newArr = new int[arr.length -1];
        //si copia l'array nel nuovo array, spostando ogni elemento di una posizione a sinistra
        //poiche' il primo elemento è stato rimosso
        for(int i = 0; i < newArr.length; i++)
            newArr[i] = arr[i + 1];
        //si salva il nuovo array nella variabile di istanza, sostituendo l'array vecchio
        arr = newArr;
        //si restituisce l'elemento tolto
        return val;
    }
    
    //metodo che restituisce il numero di elementi
    public int getNumElementi()
    {
        return arr.length;
    }
    
    //metodo che restituisce una stringa contenente la lista degli elementi
    public String toString()
    {  
        String s = "{";
        if(arr.length > 0) {
            for(int i = 0; i < arr.length-1; i++)
                s += arr[i] + ", ";
            s += arr[arr.length-1];
        }
        s += "}";
        return s;
    }
}
